﻿# IMPORTANT: Before releasing this package, copy/paste the next 2 lines into PowerShell to remove all comments from this file:
#   $f='c:\path\to\thisFile.ps1'
#   gc $f | ? {$_ -notmatch "^\s*#"} | % {$_ -replace '(^.*?)\s*?[^``]#.*','$1'} | Out-File $f+".~" -en utf8; mv -fo $f+".~" $f

$ErrorActionPreference = 'Stop' # stop on all errors
$toolsDir   = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)"
$SLMGRvbs = "C:\Windows\System32\slmgr.vbs"
$SLMGRPath = "c:\windows\system32\"

$pp = Get-PackageParameters
$KMSserver = $pp["kmsserver"] #OPTIONAL - KMS Server IP address or FQDN
$KMSserverPort = $pp["kmsserverport"] #OPTIONAL (Requires /kmsserver to be definied) Service port of the KMS Server (Default 1688)
$Key = $pp["key"] #REQUIED - Activation key in uppercase and dashed format

if (-not $Key)
{
	throw "This package requires a Windows Activation key."
}

Write-Verbose "Adding Windows Activation key"

$Addkeystatements = "/c c:\windows\system32\cscript.exe $SLMGRvbs /ipk $Key"
Start-ChocolateyProcessAsAdmin -ExeToRun "c:\windows\system32\cmd.exe" -Statements $Addkeystatements -WorkingDirectory $SLMGRPath

if ($KMSserver)
{
	if (-not ( $KMSserverPort -as [int] ))
	{
		Write-Verbose "No KMS server port definied using 1688"
		$KMSserverPort = 1688
	}
	
	Write-Verbose "Setting KMS server and port to: $$con"
	
	$con = ($KMSserver + ":" + $KMSserverPort)
	$KMSstatements = "/c c:\windows\system32\cscript.exe $SLMGRvbs /skms $con"
	Start-ChocolateyProcessAsAdmin -ExeToRun "c:\windows\system32\cmd.exe" -Statements $KMSstatements -WorkingDirectory $SLMGRPath
}

Write-Verbose "Activating Windows"
$Activatestatements = "/c c:\windows\system32\cscript.exe $SLMGRvbs /ato"
Start-ChocolateyProcessAsAdmin -ExeToRun "c:\windows\system32\cmd.exe" -Statements $Activatestatements -WorkingDirectory $SLMGRPath