﻿# IMPORTANT: Before releasing this package, copy/paste the next 2 lines into PowerShell to remove all comments from this file:
#   $f='c:\path\to\thisFile.ps1'
#   gc $f | ? {$_ -notmatch "^\s*#"} | % {$_ -replace '(^.*?)\s*?[^``]#.*','$1'} | Out-File $f+".~" -en utf8; mv -fo $f+".~" $f

$ErrorActionPreference = 'Stop' # stop on all errors
$fontSourceFolder   = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)"
$SystemFontsPath    = "C:\Windows\Fonts\"


foreach($FontFile in Get-ChildItem $fontSourceFolder -Include '*.ttf','*.ttc','*.otf' -recurse ) {
	$targetPath = Join-Path $SystemFontsPath $FontFile.Name
	if(Test-Path -Path $targetPath){
	Write-Verbose ($FontFile.Name + " already installed")
	}
	else {
	Write-Verbose ("Installing font " + $FontFile.Name)
		
		#Extract Font information for Reqistry 
		$ShellFolder = (New-Object -COMObject Shell.Application).Namespace($fontSourceFolder)
		$ShellFile = $ShellFolder.ParseName($FontFile.name)
		$ShellFileType = $ShellFolder.GetDetailsOf($ShellFile, 2)

		#Set the $FontType Variable
		If ($ShellFileType -Like '*TrueType font file*')
		{
			
		#Update Registry and copy font to font directory
			$RegName = ($ShellFolder.GetDetailsOf($ShellFile, 21) + ' (TrueType)')
		} else 
		{
			$RegName = $ShellFolder.GetDetailsOf($ShellFile, 21)
		}
		New-ItemProperty -Name $RegName -Path "HKLM:\Software\Microsoft\Windows NT\CurrentVersion\Fonts" -PropertyType string -Value $FontFile.name -Force | out-null
		Copy-item $FontFile.FullName -Destination $SystemFontsPath
		
	}
}