function openTutorials() {
   algodoo.HighlightComponent("CompID_HelpButton");
   setTimeout(function () {algodoo.OpenWidgetByID('Help')}, 750);
   setTimeout(function () {algodoo.HighlightComponent("")}, 2000);
   return false;
}

function openLessons() {
   algodoo.HighlightComponent("CompID_LessonsButton");
   setTimeout(function () {algodoo.OpenWidgetByID('LessonsBrowser')}, 750);
   setTimeout(function () {algodoo.HighlightComponent("")}, 2000);
   return false;
}

function openContent() {
   algodoo.HighlightComponent("CompID_Algobox");
   setTimeout(function () {algodoo.OpenWidgetByID('AlgoboxBrowser')}, 750);
   setTimeout(function () {algodoo.HighlightComponent("")}, 2000);
   return false;
}

function prevStep() {
    if (currentStep != 0) {
        //steps.eq(currentStep).hide('blind', { direction: "horizontal"}, 1000);
        currentStep--;
        algodoo.currentStep = currentStep;
        steps.eq(currentStep).animate({"margin-left": "+=485px"}, 750, "easeInOutQuad");
        //steps.eq(currentStep).show('blind', { direction: "horizontal", easing: "easeInOutExpo" }, 1000);
    }

    if (currentStep == 0)
        $('#buttons').hide('fade', 500);

    algodoo.HighlightComponent("");
}

function jumpSteps(steps) {
    if (steps.length == 1) {
        steps.eq(0).animate({"margin-left": "-=485px"}, 750, "easeOutQuad");
    } else {
        steps.eq(0).animate({"margin-left": "-=485px"}, 300, "linear", function () {
            jumpSteps(steps.slice(1));
        });
    }
}

function nextStep(jump) {
    jump = typeof(jump) != 'undefined' ? jump : 0;

    if (currentStep == 0)
        $('#buttons').show('fade', 1500);

    if (jump > 0) {
        var middle = steps.slice(currentStep, currentStep + jump + 1);
        jumpSteps(middle);

        currentStep += jump + 1;
        algodoo.currentStep = currentStep;

    } else {
        if (currentStep != steps.length - 1) {
            steps.eq(currentStep).animate({"margin-left": "-=485px"}, 750, "easeInOutQuad");

            // Check the step as done
            var check = steps.eq(currentStep).attr('introCheck');
            if (typeof(check) != "undefined") {
                algodoo.SetStepDone(check);
                $('#' + check + ' .checked').show();
            }

            currentStep++;
            algodoo.currentStep = currentStep;

            if (currentStep == steps.length - 1)
                algodoo.HighlightComponent("CompID_OptionsButton");
            else
                algodoo.HighlightComponent("");

        } else {
            // Hide every step except first and last
            steps.slice(1, steps.length - 1).hide();

            // Animate the last step
            steps.eq(currentStep).css({"position":"relative", "left":"-485px"});
            steps.eq(currentStep).animate({"left": "-=485px"}, 750, "easeInOutQuad");

            // Animate the first step
            steps.eq(0).animate({"margin-left": "+=485px"}, 0, "easeInOutQuad");
            steps.eq(0).css({"position":"relative", "left":485});
            steps.eq(0).animate({"left": "-=485px"}, 750, "easeInOutQuad", function () {
                // Reset every step
                steps.eq(steps.length - 1).css({"position":"static", "left":"0px"});
                steps.slice(1, steps.length - 1).show().animate({"margin-left": "+=485px"}, 0, "easeInOutQuad");
            });

            currentStep = 0;
            algodoo.currentStep = currentStep;

            $('#buttons').hide('fade', 500);

            algodoo.HighlightComponent("");
        }
    }
}

var algodoo;
var translations;
var translationsDone = 0;
$(document).ready(function () { new QWebChannel(qt.webChannelTransport, function(channel) {
    algodoo = channel.objects.algodoo;
    translations = algodoo.translations;

    // Insert translations
    $('.translate').each(function () {
        var current = $(this);
        var textId = current.html();

        Translate(textId, function (text) {
            current.html(text);
            translationsDone++;

            if (translationsDone == 11) // First page done
                $('body').show('fade', 500);
        });
    });

    // Remove the activate step, if unlocked Algodoo or MAS
    if (!algodoo.isLockedAlgodoo || algodoo.isAlgodooForMAS) {
        $('#activate').remove();
    }

    if (algodoo.isAlgodooForMAS) {
        $('#introActivate').remove();
    }

    if (algodoo.isLockedAlgodoo && algodoo.isDemoPeriodOver) {
        $('#buy').show();
    } else {
        $('#tutorials').show();
    }

    // Replace the content button with a lessons button, if For Education
    if (algodoo.hasLessons) {
        $('#lessons').show();
    } else {
        $('#content').show();
    }

    steps = $('body > div').not('.footer');

    currentStep = algodoo.currentStep;
    if (currentStep == "" || currentStep > steps.length) {
        currentStep = 0;
        algodoo.currentStep = currentStep;
    }else {
        currentStep = parseInt(currentStep);
        for (var i=0; i<currentStep; i++) {
            steps.eq(i).animate({"margin-left": "-=485px"}, 1, "easeOutBounce");
        }
    }

    $('body').append(' \
<div id="buttons"> \
    <div id="prev-button-wrap"><button id="prev-button" type="button" onclick="prevStep();">' + translations['Lesson_Prev'] + '</button></div> \
    <div id="next-button-wrap"><button id="next-button" type="button" onclick="nextStep();">' + translations['Lesson_Next'] + '</button></div> \
</div>');

    if (currentStep != 0)
        $('#buttons').delay(100).show('fade', 500);

    // Add all the languages
    var languages = algodoo.languages;
    for (var i=0; i<languages.length; i++) {
        var language = languages[i];
        $('#languages').append('<li id="' + language.name + '" onclick="algodoo.LoadLanguage(\'' + language.name + '\');"><label>' + language.name.replace("_", " ") + '</label><div class="checked"></div></li>');

        if (language.flagPath != "") {
            var flag = $("<img />");
            flag.attr("src", language.flagPath);
            $('#' + language.name).append(flag);
        }
    }

	$('.checked').hide();

    // Set the current language
    $('#' + algodoo.language + ' .checked').show();

    // Set the current skin
    var skin = algodoo.skinName;
    if (skin == "default")
        $('#default .checked').show();
    else if (skin == "white")
        $('#white .checked').show();

    // Set platform
    var touch = algodoo.isTouchInput;
    if (touch)
        $('#touch .checked').show();
    else
        $('#keyboard .checked').show();

    // Make intro links
    $('#introLanguage').click(function () {
        nextStep();
    });

    $('#introSkin').click(function () {
        nextStep(1);
    });

    $('#introPlatform').click(function () {
        nextStep(2);
    });

    stepsDone = algodoo.stepsDone;
    steps.each(function () {
        // Check if the step has been done before
        var check = $(this).attr('introCheck');
        if (typeof(check) != "undefined") {
            if (stepsDone.includes(check)) {
                $('#' + check + ' .checked').show();
            }
        }
    });

    if (!algodoo.isLockedAlgodoo) {
        $('#introActivate .checked').show();
    } else {
        $('#introActivate').click(function () {
            nextStep(3);
        });
    }

    // Disable text selection
    $('body').disableSelection();

    // Add the scrollpane
    setTimeout(function () {
        var element = $('#languages').jScrollPane({
            showArrows: true,
			verticalGutter: -2
        });

        var api = element.data('jsp');
        var scrollTo = $('#' + algodoo.language).position().top - $('#languages').position().top;
        api.scrollToY(scrollTo);
    }, 1000);
});
});
