﻿
$ErrorActionPreference = 'Stop' # stop on all errors
$toolsDir   = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)"
$ProfilePath = "$toolsDir\profile.xml"
$netshArgs = "wlan add profile filename=""$ProfilePath"" user=all"
$netshEXE = Join-Path $env:windir "System32" 
$netshEXE = $netshEXE + "\netsh.exe"

# Get parameters

$pp = Get-PackageParameters
$ParamURL = $pp["url"]
$ProfileChecksum = $pp["checksum"]
$Password = $pp["password"]

if (-not $ParamURL)
{
	throw "This package requires a Download URL."
}

if (-not $ProfileChecksum)
{
	throw "This package requires a checksum for the profile file."
}

if (-not $Password)
{
	throw "This package requires a password parameter."
}


#Edit url for download
$ProfileURLHost = ([System.Uri]$ParamURL).Host
$ProfileURL = "https://$ProfileURLHost/public.php/webdav/"

#Extract Username from the url
$Username=($ParamURL |Select-String -Pattern '\/(\w*)\/download').Matches.Groups[1].Value

#Create the auth header
$CredsBase64           = [System.Convert]::ToBase64String([System.Text.Encoding]::ASCII.GetBytes("${Username}:${Password}"))
$HeaderCreds           = @{ Headers = @{ Authorization = "Basic $CredsBase64" } }

#Download profile
$packageArgs = @{
  packageName   = $env:ChocolateyPackageName
  url           = $ProfileURL
  FileFullPath  = $ProfilePath
  softwareName  = 'Add-WifiProfile*'
  checksum      = $ProfileChecksum
  checksumType  = 'sha256'
  options       = $HeaderCreds
}

Get-ChocolateyWebFile $packageArgs


#Import the profile
Start-ChocolateyProcessAsAdmin -Statements $netshArgs -ExeToRun $netshEXE

#Remove profile file
Remove-Item -Force -Path $ProfilePath




