﻿$toolsDir   = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)"

$ErrorActionPreference = 'Stop' # stop on all errors
$packageArgs = @{
  packageName   = $env:ChocolateyPackageName
  softwareName  = 'Microsoft Office*'  #part or all of the Display Name as you see it in Programs and Features. It should be enough to be unique
  fileType      = 'EXE' #only one of these: MSI or EXE (ignore MSU for now)
  file          = join-path $toolsDir "setup.exe"
  silentArgs    = ("/configure " + (join-path $toolsDir "officeremove.xml"))
  validExitCodes= @(0, 3010, 1605, 1614, 1641) # https://msdn.microsoft.com/en-us/library/aa376931(v=vs.85).aspx
}


Uninstall-ChocolateyPackage @packageArgs
